# -*- coding: utf-8 -*-
"""
Created on Mon Nov 22 15:26:34 2021

@author: georg
"""


import sympy as sym
import os




def createLatexFile(string):
    
    latexStr = '' 
    latexStr += '\documentclass[showpacs,preprintnumbers,amsmath,amssymb,notitlepage,preprint]{revtex4-2} \n'
    latexStr +=  '\\usepackage{bbm}\n'
    latexStr += '\\usepackage{setspace}\n'
    latexStr += '\\usepackage[ a0paper , hmargin = { 3cm } , height= 10in,landscape ]{geometry}\n'
    
    
    
    latexStr += '\\begin{document}\n'
    
    latexStr +=   string +'\n'
    
    latexStr += '\\end{document}\n'
    
    
    return latexStr



    
    


def polynomial():
    
    
    eqStr = 'Calculations \n'
    
    
    
    #Defintion of the symbols
    eps= sym.symbols(r'\epsilon   ',real=True,postive=True)   
    omegaPl , omegaMi = sym.symbols(r'\Omega_{+} \Omega_{-}  ', complex=True)    
    

    chi1, chi2= sym.symbols(r'  \chi_{1} \chi_{2} ',real=True,postive=True)
    gamma= sym.symbols(r' \gamma ',real=True,postive=True) 


    z  = sym.symbols('z')
    

    omegaPlC = sym.conjugate(omegaPl)  
    omegaMiC =  sym.conjugate(omegaMi)    
 
    
    
    a00 = 0
    a01 =-1j* omegaPlC/2 
    a02 = 1j* omegaMi/2 
    a03 =  gamma 
    
    a10 = -1j* omegaPl/2 
    a11 =  -1j*eps -gamma/2
    a12 =  0 
    a13 =   1j*omegaMi/2  
    
    a20 = 1j* omegaMiC/2  
    a21 = 0 
    a22 = +1j*eps -gamma/2
    a23 =  -1j*  omegaPlC/2
    
    
    a30 = 0
    a31 = 1j* omegaMiC/2
    a32 = -1j* omegaPl/2
    a33 = -gamma
    
    
    
    
    M = sym.Matrix( [[a00,a01,a02,a03], [a10,a11,a12,a13] ,[a20,a21,a22,a23] ,[a30,a31,a32,a33]   ]   )
    
    
    
    #--------------------------------------------------------------------------
    #Calculating the spontaneous emission

    polyNom = M.charpoly(z)
    
    
    eqStr  += 'Step 1: Polynomial no symplification \n'
    eqStr  += '\\begin{eqnarray}\n'
    eqStr  += sym.latex( polyNom )  +'\n'
    eqStr  +=   '\end{eqnarray}\n'    
    
    coef_ls = polyNom.all_coeffs()
    for  j in range( len( coef_ls)  ) :
        coef_ls[j] =sym.simplify(coef_ls[j])
        
        
        
        eqStr  += 'Coefficient '+ str(j)+ ':\n'
        eqStr  += '\\begin{eqnarray}\n'
        eqStr  += sym.latex(coef_ls[j])  +'\n'
        eqStr  +=   '\end{eqnarray}\n'    
    
    
    #--------------------------------------------------------------------------
    #Export into  a letex file
    eqStr = createLatexFile(eqStr)
    text_file = open("calculations.tex", "wt")
    text_file.write(eqStr)
    text_file.close()
    os.system('pdflatex calculations.tex')
    os.system('.\calculations.pdf')     
    

    
     
     
if __name__ =='__main__':
    
    hz =1.2
    g= 0.4
    phiR,phiL = 0.0,0
    gamma =2
    xi  =  0
    dXi =2

    


    
    polynomial()
    
