# -*- coding: utf-8 -*-
"""
Created on Mon Nov 22 15:26:34 2021

@author: georg engelhardt
"""



import numpy as np
from matplotlib import pyplot as plt
import prftSpectroscopyAux as prftsa


###############################################################################
###############################################################################
###############################################################################
#Meam and variance of the spontaneous and stimulated currents 
#Definition of the general Liovillian



def vectorTensorDot(A,B):
    Asp = A.shape
    Bsp = B.shape

    a1, a2 = Asp[0], Asp[1]
    b1, b2 = Bsp[0], Bsp[1]
    
    M = np.zeros((a1*b1, a2*b2), dtype=complex  )
    for i in range(a1):
        for j in range(a2):
            M[i*b1:(i+1)*b1 ,j*b2:(j+1)*b2 ] = A[i,j]*B.T
    
    return M
    


def liouvillian(paramCons, rabiFreqs , chi_ar):
    
    
    
    epsA, epsB, epsC  = paramCons[0], paramCons[1], paramCons[2], 
    gCoup = paramCons[3]
    gamma1,gamma2 = paramCons[4],paramCons[5],
    epsD =  paramCons[6]
    gLO =  paramCons[7]
    
    
    g0,g1 = rabiFreqs[0],rabiFreqs[1]
    chi0,chi1 = chi_ar[0]  /2,  chi_ar[1]/2
    
    phi = np.pi/2

    g0Left   = g0*np.exp( 1j* ( - phi/2 + chi0)) 
    g0LeftC  = np.conjugate(g0Left)
    g0Right  = g0*np.exp( 1j* (-phi/2  - chi0))  
    g0RightC = np.conjugate(g0Right)
    
    
    g1Left   = g1*np.exp( 1j* (  phi/2  + chi1)) 
    g1LeftC  = np.conjugate(g1Left)
    g1Right  = g1*np.exp(1j* ( phi/2  - chi1))  
    g1RightC = np.conjugate(g1Right)
    
    
    hamL = [[epsA,g0LeftC+ g1LeftC,0,0],
            [g0Left+ g1Left,epsB,gCoup,0],
            [0,gCoup,epsC, gLO ],
            [0, 0 ,   gLO, epsD ]]
    hamL = np.array(hamL)
    
    hamR = [[epsA,g0RightC+ g1RightC,0,0],
            [g0Right+ g1Right,epsB,gCoup,0],
            [0,gCoup,epsC, gLO ],
            [0, 0 ,   gLO, epsD ]]
    hamR = np.array(hamR)
    
     
    identity = np.identity(4)
    
    diss1 = [[0,1,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            ]
    diss1 = np.array(diss1)
    diss1HC = np.conjugate(diss1.T)
    
    diss2 = [[0,0,1,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            ]
    diss2 = np.array(diss2)
    diss2HC = np.conjugate(diss2.T)
    
    diss3 = [[0,0,0,1],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            ]
    diss3 = np.array(diss3)
    diss3HC = np.conjugate(diss3.T)
    

    liouv0 =  vectorTensorDot(-1j* hamL, identity)
    liouv0 +=  vectorTensorDot(identity,1j* hamR)
    
    liouv0 -= gamma1* vectorTensorDot(np.dot(diss1HC,diss1)  , identity)
    liouv0 -=  gamma1*vectorTensorDot(identity, np.dot(diss1HC,diss1) )
    liouv0 += gamma1*2 * vectorTensorDot( diss1 , diss1HC  )
    
    liouv0 -= gamma2* vectorTensorDot(np.dot(diss2HC,diss2)  , identity)
    liouv0 -=  gamma2*vectorTensorDot(identity, np.dot(diss2HC,diss2) )
    liouv0 +=   gamma2*2 * vectorTensorDot( diss2 , diss2HC  )
    
    liouv0 -= gamma2* vectorTensorDot(np.dot(diss3HC,diss3)  , identity)
    liouv0 -=  gamma2*vectorTensorDot(identity, np.dot(diss3HC,diss3) )
    liouv0 +=   gamma2*2 * vectorTensorDot( diss3 , diss3HC  )
    

    return liouv0 



            


def extendedLambdaSystem_fisherInfo_detuning1(dic):
    
    
    hbar = 6.62e-34
    c = 3e8
    eps0 =8.86e-12
    
    detuning1Min = dic['detuning1_Mhz_min']
    detuning1Max = dic['detuning1_Mhz_max']
    detuning1Nmb = dic['detuning1_Mhz_nmb']
    detuning1 = 10
    detuning2 = dic['detuning2_Mhz']
    elecDipole = dic['elecDipole_eaB'] * 1.6e-19 * 5e-11
    gamma1 = dic['gamma1_Mhz']
    gamma2 = dic['gamma2_Mhz']
    laserPower = dic['laserPower_W']
    diameter = dic['diameterLaser_m']
    pulseTau = dic['samplingTime_s']*1e6
    rhoAtom = dic['rhoAtom_m3']
    laserWavelength = dic['laserWaveLength_nm']*1e-9
    gCoup = dic['gCoup_Mhz']
    gLO = dic['gLO_Mhz']


    paramCons = np.array([ detuning1,0,detuning2,gCoup ,  gamma1 , gamma2, detuning2,gLO ],dtype=float)
    
    
    laserFrq =  2*np.pi*c/laserWavelength
    nMean = laserPower*pulseTau*1e-6/hbar/laserFrq
    n0Mean = nMean/2
    n1Mean = nMean/2
    n_ar = np.array([n0Mean,n1Mean])
    sigmaQ_ar= np.array([[n0Mean,0],[0,n1Mean]])
    areaLaser= np.pi*diameter*diameter/4
    
    
    
    
    
    intensity =laserPower/(np.pi*diameter*diameter/4)
    elField = np.sqrt( 2* intensity/(c*eps0))
    rabiFrq = elField*elecDipole/hbar*1e-6
    rabiFrqs = np.array( [rabiFrq,rabiFrq ])
    
    print('initial n0Mean:', np.log10( n0Mean ) )
    print('laserFrq:', np.log10( laserFrq)  )
    print('Rabi frequency:', rabiFrq )
    print('nMean:', nMean )
    print('paramCons',paramCons)
    
    zMax = dic['zMax_m']
    dz = dic['dz_m']
    zNmb = dic['zNmb']
    idxFish = dic['index_fisher']
    dChi = dic['dChi']
    
    
    rotationAngleEst =  rabiFrq*rabiFrq/(detuning1+gamma1)/nMean *pulseTau   *rhoAtom*areaLaser*zMax
    print('Estimated rotation Angle', rotationAngleEst)
     
    
    detuning1_ar =  np.linspace(detuning1Min,detuning1Max,detuning1Nmb)  
    

    
    out_ar = np.zeros( (detuning1Nmb,31)    )  
    for i, detuning1  in enumerate(detuning1_ar)  :
       
        paramCons[0]= detuning1
        
        out_ar[i,0]=detuning1
        out_ar[i,1:11] = prftsa.flowEquations_signalNoise(liouvillian,paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax,zNmb,dz
                                           ,idxFish ,dChi,showProgress=False)[-1,1:]
        
        out_ar[i,11:17] = prftsa.transportCoefficients(liouvillian, paramCons, rabiFrqs ,dChi)
        
        
        print('Progress:' , np.round( i/detuning1Nmb*100,1),'%, detuning1_MHz:' , detuning1)

        
    saveName = 'extendedLambdaSystem_fisherInfo_detuning1-' + dic['saveExtension'] + '.npy'        
    saveName =  dic['savePath'] +  saveName 
    np.save(saveName , out_ar )     
    print('\n extendedLambdaSystem_fisherInfo_detuning1 saved at: ' , saveName )     







if __name__ =='__main__':
    
    pass
 