# -*- coding: utf-8 -*-
"""
Created on Mon Nov 22 15:26:34 2021

@author: georg
"""


import numpy as np
from matplotlib import pyplot as plt
import prftSpectroscopyAux as prftsa


###############################################################################
###############################################################################
###############################################################################
#Meam and variance of the spontaneous and stimulated currents 
#Definition of the general Liovillian




def liouvillian(paramCons, rabiFreqs , chi_ar):
    

    hz = paramCons[0]
    gammaD = paramCons[1]
    gammaU = paramCons[2]
    phi1 = paramCons[3]
    phi2 = paramCons[4]
    
    g1 = rabiFreqs[0]
    g2 = rabiFreqs[1]
    dChi1= chi_ar[0]/2
    dChi2= chi_ar[1]/2
    
    
    grR= g1* np.cos(phi1  + dChi1 ) +  g2* np.cos(phi2  + dChi2  )
    grL = g1* np.cos(phi1 -dChi1  ) + g2* np.cos(phi2  -dChi2   )
    giR= g1* np.sin(phi1  + dChi1)  + g2* np.sin(phi2  + dChi2 ) 
    giL = g1* np.sin(phi1 -dChi1)  + g2*  np.sin(phi2  - dChi2)
    
    
    a00 = -2*gammaD*(1- 1  )   -2*gammaU*(1- 1  )  
    a01 =1j*  ( grR  -  grL  ) 
    a02 = 1j*  ( giR   -  giL  ) 
    a03 =  -2*gammaD*(1- 1  )  + 2*gammaU*(1-1  )  
    
    a10 = 1j*  ( grR  -  grL    ) 
    a11 = -2*gammaD - 2 * gammaU
    a12 = -hz
    a13 =   (giR   +  giL ) 
    
    a20 = 1j*  (giR   -  giL  ) 
    a21 = hz
    a22 = -2*gammaD- 2 * gammaU
    a23 =  -  ( grR  +  grL  ) 
    
    
    a30 = -2*gammaD*(1+ 1  ) + 2*gammaU*(1+ 1  ) 
    a31 = -  ( giR   +  giL ) 
    a32 =   ( grR  +  grL  ) 
    a33 = -2*gammaD*(1+ 1 )  -2*gammaU*(1+ 1  )
     
    
    
    M = np.array( [[a00,a01,a02,a03], [a10,a11,a12,a13] ,[a20,a21,a22,a23] ,[a30,a31,a32,a33]   ]   )
    
    
    return M




def transportCoefficients_analytic( paramCons, rabiFrqs):
    
    
    g =  rabiFrqs[0]
    hz = paramCons[0]
    gammaD = paramCons[1]
    


    nom = (0.25*hz*hz +  g*g  ) 
    nomEx = (0.25*hz*hz +  g*g + gammaD*gammaD ) 
    
    dnd1t = (g*2*hz*g -4*gammaD*g*g)*0.25
    dnd1t /=  nomEx
    dnd2t = (-g*2*hz*g- 4*gammaD*g*g)*0.25 
    dnd2t /=  nomEx
    
    dsdtA = g*g*g*g*g*g*g*g/2
    dsdtA /=nom*nom*nom*gammaD
    dsdtB = g*g*g*g*g*g*8*hz*(-1)/16
    dsdtB /=nom*nom*nom
    dsdtC = g*g*nom*nom*nom + g*g*hz*hz*hz*hz*hz*hz
    dsdtC /=nom*nom*nom*nom/gammaD*2
    dsdtD = g*g*nom*nom*nom - g*g*hz*hz*hz*hz*hz*hz
    dsdtD /=nom*nom*nom*nom/gammaD*2
    
    dsdtdiag= dsdtA +  dsdtC 
    dsdtnondiag= -dsdtA +  dsdtD 
    
    dndt = np.array( [dnd1t,dnd2t] )
    dsdt = np.array( [ [dsdtdiag+ dsdtB,dsdtnondiag] ,[dsdtnondiag,dsdtdiag- dsdtB]  ] )
    
    
    return   dndt   ,  dsdt



def fisherInfo_Density_analytic(paramCons, rabiFrqs ,
                                  n_ar, sigmaQ_ar,pulseTau,
                                  rhoAtom, areaLaser,
                                  zMax, idxFisher=-1 ) :
    
    
    out = np.zeros((13,) ) 
    dndt   ,  dsdt = transportCoefficients_analytic( paramCons, rabiFrqs)
    dLambda = rhoAtom* 0.00001
    
    
    
    
    nMean = n_ar + dndt * zMax*rhoAtom*areaLaser*pulseTau
    sigmaQ = sigmaQ_ar+ dsdt * zMax*rhoAtom*areaLaser*pulseTau
    nTot = nMean[0]+nMean[1]
    theta = (nMean[0]-nMean[1])/nTot/2
    n00 = nTot/2
    n01 = nTot/2
    
    
    if idxFisher ==-1:
    
        nMean1 = n_ar + dndt * zMax*(rhoAtom+ dLambda)*areaLaser*pulseTau
        nTot1= ( nMean1[0]+nMean1[1])
        theta1= (nMean1[0]-nMean1[1])/nTot1/2
        
    else:
        if paramCons[idxFisher] ==0:
            dLambda =  0.0001
        else:
            dLambda = paramCons[idxFisher]*0.001
        
        paramCons1= paramCons+0
        paramCons1[idxFisher] += dLambda
        dndt   ,  dsdt = transportCoefficients_analytic( paramCons1, rabiFrqs)
        nMean1 = n_ar + dndt * zMax*rhoAtom*areaLaser*pulseTau
        nTot1= ( nMean1[0]+nMean1[1])
        theta1= (nMean1[0]-nMean1[1])/nTot1/2
    
    
    
    
    
    delta_theta = theta1 -theta
    n10 = (np.cos(delta_theta)+ np.sin(delta_theta))*np.sqrt(nTot1/2)
    n11 = (np.cos(delta_theta)- np.sin(delta_theta))*np.sqrt(nTot1/2)
    n10*=n10
    n11*=n11
    
    
    n0_ar = np.array([n00,n01])
    n1_ar = np.array([n10,n11])
    fisherInfo  = prftsa.fisherInformation(n0_ar,sigmaQ ,n1_ar,sigmaQ ,dLambda)
    

    out[0] = nTot
    out[1] = theta
    out[2:6] = sigmaQ.flatten()
    out[6]=  fisherInfo[0]
    out[7:9] = dndt.flatten()
    out[9:13] = dsdt.flatten()

    
    return out



def fisherInfo_fullAnalytic(paramCons, rabiFrqs ,
                                  n_ar, sigmaQ_ar,pulseTau,
                                  rhoAtom, areaLaser,
                                  zMax ) :
    
    nAtom = zMax*rhoAtom*areaLaser
    rabiFreq = 2*rabiFrqs[0] 
    hz = paramCons[0]
    gammaD = paramCons[1]
    nTot = n_ar[0]*2
    
    
    noise = nTot + 0.5*pulseTau*nAtom*np.power(rabiFreq,8)/gammaD/np.power(hz*hz + rabiFreq *rabiFreq ,3 )
    
    signaDens = pulseTau*zMax*areaLaser * hz* rabiFreq *rabiFreq /(hz*hz + rabiFreq *rabiFreq  )
    signalhz = pulseTau*nAtom *rabiFreq *rabiFreq*( hz* hz- rabiFreq *rabiFreq )   /np.power(hz*hz + rabiFreq *rabiFreq ,2 )
    
    
    fInfoDens = signaDens*signaDens/ noise
    fInfohz =  signalhz*signalhz/ noise
    
    return  fInfoDens , fInfohz



def twoLevelSystem_signalNoise_position(dic):
    

    hbar = 6.62e-34
    c = 3e8
    eps0 =8.86e-12
    

    detuning = dic['detuning_Mhz']
    elecDipole = dic['elecDipole_eaB'] * 1.6e-19 * 5e-11
    gammaD = dic['gammaD_Mhz']
    gammaU = dic['gammaU_Mhz']
    laserPower = dic['laserPower_W']
    diameter = dic['diameterLaser_m']
    pulseTau = dic['samplingTime_s']*1e6
    rhoAtom = dic['rhoAtom_m3']
    laserWavelength = dic['laserWaveLength_nm']*1e-9
    phi1 = 0
    phi2 = np.pi/2
    paramCons = np.array([detuning ,  gammaD , gammaU , phi1 , phi2])
    laserFrq =  2*np.pi*c/laserWavelength
    nMean = laserPower*pulseTau*1e-6/hbar/laserFrq
    n0Mean = nMean/2
    n1Mean = nMean/2
    n_ar = np.array([n0Mean,n1Mean])
    sigmaQ_ar= np.array([[n0Mean,0],[0,n1Mean]])
    areaLaser= np.pi*diameter*diameter/4
    

    intensity =laserPower/(np.pi*diameter*diameter/4)
    elField = np.sqrt( 2* intensity/(c*eps0))
    rabiFrq = elField*elecDipole/hbar*1e-6
    rabiFrqs = np.array( [rabiFrq,rabiFrq ])
    
    print('initial n0Mean:', np.log10( n0Mean ) )
    print('laserFrq:', np.log10( laserFrq)  )
    print('Rabi frequency:', rabiFrq )
    print('nMean:', nMean )
    
    
    zMax = dic['zMax_m']
    zNmb = dic['zNmb']
    dz = dic['dz_m']
    idxFish = -1
    dChi = dic['dChi']
    
    
    rotationAngleEst =  rabiFrq*rabiFrq/(detuning+gammaD)/nMean *pulseTau   *rhoAtom*areaLaser*zMax
    print('Estimated rotation Angle', rotationAngleEst)

    
    out_ar = prftsa.flowEquations_signalNoise(liouvillian,paramCons, rabiFrqs ,
                                     n_ar, sigmaQ_ar,pulseTau,
                                     rhoAtom, areaLaser,
                                     zMax,zNmb,dz
                                      ,idxFish ,dChi)
    
    
    
    savePath =  dic['savePath']
    saveExtension =  dic['saveExtension']
    saveName = 'flowEquations_signalNoise_twoLevelSystem_density+' +saveExtension + '.npy'        
    saveName =  savePath +  saveName 
    np.save(saveName , out_ar )     
    print('\n flowEquations_signalNoise_twoLevelSystem_density saved at: ' , saveName ) 
    
      


def twoLevelSystem_fisherInfo_detuning(dic):
    
    
    hbar = 6.62e-34
    c = 3e8
    eps0 =8.86e-12
    
    detuningMin = dic['detuning_Mhz_min']
    detuningMax = dic['detuning_Mhz_max']
    detuningNmb = dic['detuning_Mhz_nmb']
    detuning = 10
    
    elecDipole = dic['elecDipole_eaB'] * 1.6e-19 * 5e-11
    gammaD = dic['gammaD_Mhz']
    gammaU = dic['gammaU_Mhz']
    laserPower = dic['laserPower_W']
    diameter = dic['diameterLaser_m']
    pulseTau = dic['samplingTime_s']*1e6
    rhoAtom = dic['rhoAtom_m3']
    laserWavelength = dic['laserWaveLength_nm']*1e-9
    phi1 = 0
    phi2 = np.pi/2
    paramCons = np.array([detuning ,  gammaD , gammaU , phi1 , phi2])
    
    
    laserFrq =  2*np.pi*c/laserWavelength
    nMean = laserPower*pulseTau*1e-6/hbar/laserFrq
    n0Mean = nMean/2
    n1Mean = nMean/2
    n_ar = np.array([n0Mean,n1Mean])
    sigmaQ_ar= np.array([[n0Mean,0],[0,n1Mean]])
    areaLaser= np.pi*diameter*diameter/4
    intensity =laserPower/(np.pi*diameter*diameter/4)
    elField = np.sqrt( 2* intensity/(c*eps0))
    rabiFrq = elField*elecDipole/hbar*1e-6
    rabiFrqs = np.array( [rabiFrq,rabiFrq ])
    
    print('initial n0Mean:', np.log10( n0Mean ) )
    print('laserFrq:', np.log10( laserFrq)  )
    print('Rabi frequency:', rabiFrq )
    print('nMean:', nMean )
    
    zMax = dic['zMax_m']
    zNmb = 100
    dz = dic['dz_m']
    idxFish = dic['index_fisher']
    dChi = dic['dChi']
    
    
    rotationAngleEst =  rabiFrq*rabiFrq/(detuning+gammaD)/nMean *pulseTau   *rhoAtom*areaLaser*zMax
    print('Estimated rotation Angle', rotationAngleEst)
     
    
    detuning_ar =  np.linspace(detuningMin,detuningMax,detuningNmb)  
  
    
    out_ar = np.zeros( (detuningNmb,33)    )  
    for i, detuning  in enumerate(detuning_ar)  :
       
        paramCons[0]= detuning
        
        
        out_ar[i,0]=detuning
        out_ar[i,1:11] = prftsa.flowEquations_signalNoise(liouvillian,paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax,zNmb,dz
                                           ,idxFish ,dChi,showProgress=False)[-1,1:]
        
        
        out_ar[i,11:17] = prftsa.transportCoefficients(liouvillian, paramCons, rabiFrqs ,dChi)
        
        out_ar[i,17:30] = fisherInfo_Density_analytic(paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax ) 
        
        out_ar[i,30:32] = fisherInfo_fullAnalytic(paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax )
        
        
        print('Progress:' , np.round( i/detuningNmb*100,1),'%')
        

 
        
        
    saveName = 'twoLevelSystem_fisherInfo_detuning-' + dic['saveExtension'] + '.npy'        
    saveName =  dic['savePath'] +  saveName 
    np.save(saveName , out_ar )     
    print('\n twoLevelSystem_fisherInfo_detuning saved at: ' , saveName )     





def twoLevelSystem_fisherInfo_pump(dic):
    
    
    hbar = 6.62e-34
    c = 3e8
    eps0 =8.86e-12
    
    gammaDMin = dic['gammaD_Mhz_min']
    gammaDMax = dic['gammaD_Mhz_max']
    gammaDNmb = dic['gammaD_Mhz_nmb']
    gammaD = gammaDMin
    
    
    detuning = dic['detuning_Mhz']
    elecDipole = dic['elecDipole_eaB'] * 1.6e-19 * 5e-11
    gammaD = dic['gammaD_Mhz']
    gammaU = dic['gammaU_Mhz']
    laserPower = dic['laserPower_W']
    diameter = dic['diameterLaser_m']
    pulseTau = dic['samplingTime_s']*1e6
    rhoAtom = dic['rhoAtom_m3']
    laserWavelength = dic['laserWaveLength_nm']*1e-9
    phi1 = 0
    phi2 = np.pi/2
    paramCons = np.array([detuning ,  gammaD , gammaU , phi1 , phi2])
    
    
    laserFrq =  2*np.pi*c/laserWavelength
    nMean = laserPower*pulseTau*1e-6/hbar/laserFrq
    n0Mean = nMean/2
    n1Mean = nMean/2
    n_ar = np.array([n0Mean,n1Mean])
    sigmaQ_ar= np.array([[n0Mean,0],[0,n1Mean]])
    
    areaLaser= np.pi*diameter*diameter/4
    
    
    print('initial n0Mean:', np.log10( n0Mean ) )
    
    
    intensity =laserPower/(np.pi*diameter*diameter/4)
    elField = np.sqrt( 2* intensity/(c*eps0))
    rabiFrq = elField*elecDipole/hbar*1e-6
    rabiFrqs = np.array( [rabiFrq,rabiFrq ])
    
    print('laserFrq:', np.log10( laserFrq)  )
    print('Rabi frequency:', rabiFrq )
    print('nMean:', nMean )
    
    
    zMax = dic['zMax_m']
    zNmb = dic['zNmb']
    dz = dic['dz_m']
    idxFish = dic['index_fisher']
    dChi = dic['dChi']
    
    
    rotationAngleEst =  rabiFrq*rabiFrq/(detuning+gammaD)/nMean *pulseTau   *rhoAtom*areaLaser*zMax
    print('Estimated rotation Angle', rotationAngleEst)
     
    
    gammaD_ar =  np.logspace(np.log10( gammaDMin),np.log10(gammaDMax),gammaDNmb)  
    out_ar = np.zeros( (gammaDNmb,33)    )  
 
        
    for i, gammaD  in enumerate(gammaD_ar)  :
        paramCons[1]=gammaD
        out_ar[i,0]=gammaD
        out_ar[i,1:11] = prftsa.flowEquations_signalNoise(liouvillian,paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax,zNmb,dz
                                           ,idxFish ,dChi,showProgress=False)[-1,1:]
        
        
        out_ar[i,11:17] = prftsa.transportCoefficients(liouvillian, paramCons, rabiFrqs ,dChi)
        
        out_ar[i,17:30] = fisherInfo_Density_analytic(paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax , idxFisher=idxFish) 
        
        out_ar[i,30:32] = fisherInfo_fullAnalytic(paramCons, rabiFrqs ,
                                          n_ar, sigmaQ_ar,pulseTau,
                                          rhoAtom, areaLaser,
                                          zMax )
        
        
        
        print('Progress:' , np.round( i/gammaDNmb*100,1),'%')
       

        
        
    saveName = 'twoLevelSystem_fisherInfo_pump-' + dic['saveExtension'] + '.npy'        
    saveName =  dic['savePath'] +  saveName 
    np.save(saveName , out_ar )     
    print('\n twoLevelSystem_fisherInfo_pump saved at: ' , saveName ,'\n')     
    
    
    
       




if __name__ =='__main__':
    
    pass
 