# -*- coding: utf-8 -*-
"""
Created on Thu May 18 16:57:33 2023

@author: Georg Engelhardt
"""

import os
import sys
import numpy as np


import prftSpectroscopyAuxTwoLevelSystem as prftsatls
import prftSpectroscopyAuxExtendedLambdaSystem as prftaels

currentDir = os.getcwd()
pathData= currentDir +'/lists0/'


###############################################################################
###############################################################################

args = sys.argv

if len(args)==1:
    core_nmb=1
    task_ls=[900]

else:
    core_nmb= int( args[1] )
    task_info = args[2] 
    task_info =task_info[1:-1]
    task_ls= task_info.split(',')
    
    print('Test task ls:' ,task_ls  )
    for i in range(len(task_ls) ):
        task_ls[i] = int(task_ls[i] )
    path_largeData= '/vol7/home/georg/dataDeposit/'
    

print('Task list: ', task_ls)
print('Core number: ' , core_nmb )
print(os.getcwd() )


###############################################################################
###############################################################################
###############################################################################
###############################################################################


dic ={

'savePath' : pathData ,

}


if 400 in task_ls:
    #Figure 4: probility as a function of position
    
    dic['detuning_Mhz'] =   100
    dic['elecDipole_eaB'] = 5
    dic['gammaD_Mhz'] =  1
    dic['gammaU_Mhz'] = 0
    dic['laserPower_W'] = 10e-3
    dic['diameterLaser_m'] = 0.01
    dic['samplingTime_s'] = 1
    dic['rhoAtom_m3'] =  1e15
    dic['laserWaveLength_nm'] =  500
    
    
    dic['zMax_m'] = 0.1
    dic['zNmb'] = 100
    dic['dz_m']  = 1e-4
    dic['dChi']= 0.001
    

    dic['saveExtension'] = 'test'
    prftsatls.twoLevelSystem_signalNoise_position(dic)
    
    
    
    
    
    
if 500 in task_ls:
    #Figure 5 and Figure 6: Analsis of the Two-level system
    
    
    dic['detuning_Mhz_min'] = -400
    dic['detuning_Mhz_max'] = 400
    dic['detuning_Mhz_nmb'] = 200
    dic['elecDipole_eaB'] = 5
    dic['gammaD_Mhz'] =    1
    dic['gammaU_Mhz'] =   0
    dic['laserPower_W'] = 10e-3
    dic['diameterLaser_m'] = 0.01
    dic['samplingTime_s'] = 1
    dic['rhoAtom_m3'] =  1e14
    dic['laserWaveLength_nm'] =  500
    
    
    dic['zMax_m'] =0.1
    dic['zNmb'] = 100
    dic['dz_m']  =1e-4
    dic['dChi']= 0.001
    
    
    dic['index_fisher']=-1
    
    dic['saveExtension'] = 'largePower'
    dic['laserPower_W'] = 100e-3
    prftsatls.twoLevelSystem_fisherInfo_detuning(dic)
    
    
    
    dic['index_fisher']=0
    
    dic['saveExtension'] = 'largePower-detuning'
    dic['laserPower_W'] = 100e-3
    prftsatls.twoLevelSystem_fisherInfo_detuning(dic)
    
    
    
    
    
    
    

if 700 in task_ls:
    #Figure 7: Analysis of the Two-level system as a function of dissipation/pump

    dic['elecDipole_eaB'] = 5
    dic['gammaD_Mhz'] =    1
    dic['gammaU_Mhz'] =   0

    dic['diameterLaser_m'] = 0.01
    dic['samplingTime_s'] = 1
    dic['rhoAtom_m3'] =  1e14
    dic['laserWaveLength_nm'] =  500
    
    dic['zMax_m'] =0.01
    dic['zNmb'] = 2
    dic['dz_m']  =1e-5
    dic['dChi']= 0.001
    
    dic['laserPower_W'] = 10e-3
    
    dic['gammaD_Mhz_min'] = 1e-2
    dic['gammaD_Mhz_max'] = 1e3
    dic['gammaD_Mhz_nmb'] = 20
    dic['dChi']= 0.0001
    
    
    dic['index_fisher']=-1
    
    
    dic['saveExtension'] = 'detuningZero'
    dic['detuning_Mhz'] = 1
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningSmall'
    dic['detuning_Mhz'] = 15
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningMedium'
    dic['detuning_Mhz'] = 30
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningLarge'
    dic['detuning_Mhz'] = 45
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    
    
    dic['index_fisher']=0
    
    dic['saveExtension'] = 'detuningZero-detuning'
    dic['detuning_Mhz'] = 1
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningSmall-detuning'
    dic['detuning_Mhz'] = 15
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningMedium-detuning'
    dic['detuning_Mhz'] = 30
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
    dic['saveExtension'] = 'detuningLarge-detuning'
    dic['detuning_Mhz'] = 45
    prftsatls.twoLevelSystem_fisherInfo_pump(dic)
    
 


if 900 in task_ls:
    #Figure 9 and figure 10: analysis of the  extended lanmda system 
    
    
    dic['detuning1_Mhz_min'] = -100
    dic['detuning1_Mhz_max'] =100
    dic['detuning1_Mhz_nmb'] = 1000
    dic['detuning2_Mhz'] = 0
    
    dic['gCoup_Mhz'] = 20
    dic['gLO_Mhz'] = 3
    
    dic['elecDipole_eaB'] = 5
    dic['gamma1_Mhz'] =    0.1
    dic['gamma2_Mhz'] =   0.0
    dic['laserPower_W'] = 10e-3
    dic['diameterLaser_m'] = 0.01
    dic['samplingTime_s'] = 1
    dic['rhoAtom_m3'] =  5e13
    dic['laserWaveLength_nm'] =  500
    
    
    dic['zMax_m'] =0.1
    dic['zNmb'] = 2
    dic['dz_m']  =1e-3
    dic['dChi']= 0.00001
    
    dic['index_fisher']=7
    

    
    dic['saveExtension'] = 'smallPower-LO'
    dic['laserPower_W'] = 0.1e-3
    prftaels.extendedLambdaSystem_fisherInfo_detuning1(dic)
    

    

    

