# -*- coding: utf-8 -*-
"""
Created on Thu May 18 17:10:41 2023

@author: Administrator
"""

import numpy as np
import matplotlib.pyplot as plt
import os
import matplotlib.gridspec as gridspec
import matplotlib.patches as patches
from matplotlib.patches import FancyArrowPatch


currentDir = os.getcwd()
pathData= currentDir + '/lists0/'
os.chdir('..')
print(os.getcwd())


###############################################################################
###############################################################################
#functions


def fixedMeasurementBasis(val_ar):
    
    
    nHalf = val_ar[:,1]/2 
    
    thetaAr =   val_ar[:,2]
    n0_ar = ( np.cos(thetaAr )-  np.sin(thetaAr)  )  * np.sqrt( nHalf )
    n1_ar =( np.cos(thetaAr )+  np.sin(thetaAr)  )  * np.sqrt( nHalf ) 
    n0_ar = n0_ar *n0_ar 
    n1_ar = n1_ar *n1_ar 
    
    
    
    sigma_ar = np.zeros( (len(thetaAr),2,2  )  ) 
    
    for j in range(len(thetaAr)): 
        theta =thetaAr[j]
        rot =np.array(  [[np.cos(theta ) ,np.sin(theta) ],[-np.sin(theta) ,np.cos(theta ) ]])
        
        
        tmp = np.array( [[val_ar[j,3],val_ar[j,4] ],[val_ar[j,5],val_ar[j,6]]])
        tmp = np.dot(tmp, rot.T  )
        tmp =  np.dot(rot ,  tmp )
        
        
        tmp[0,0] *= np.sqrt( n0_ar[j]* n0_ar[j] / nHalf[j] / nHalf[j])
        tmp[0,1] *= np.sqrt( n0_ar[j]* n1_ar[j] / nHalf[j] / nHalf[j])
        tmp[1,0] *= np.sqrt( n1_ar[j]* n0_ar[j] / nHalf[j] / nHalf[j])
        tmp[1,1] *= np.sqrt( n1_ar[j]* n1_ar[j] / nHalf[j] / nHalf[j])
        
        
        sigma_ar[j] = tmp
        
    return n0_ar ,n1_ar,sigma_ar


def rotatedMeasurementBasis(val_ar):
    
    
    nHalf = val_ar[:,1]/2 
    
    thetaAr =   val_ar[:,2]
    n0_ar  =  np.sqrt( nHalf )
    n1_ar  = np.sqrt( nHalf ) 
    n0_ar  = n0_ar *n0_ar 
    n1_ar  = n1_ar *n1_ar 
    
    
    sigma_ar = np.zeros( (len(thetaAr),2,2  )  ) 
    
    for j in range(len(thetaAr)): 

        tmp = np.array( [[val_ar[j,3],val_ar[j,4] ],[val_ar[j,5],val_ar[j,6]]])
        sigma_ar[j] = tmp
        
    return thetaAr, n0_ar ,n1_ar,sigma_ar




def probilityDistribution(val_ar, j, deltaN, nNmb, rotQ = False):
    
    nHalf = val_ar[j,1]/2 
    
    if rotQ ==False:
        theta =   val_ar[j,2]
    else:
        theta=0
        
        
    n0 = ( np.cos(theta )-  np.sin(theta)  )  * np.sqrt( nHalf )
    n1 =( np.cos(theta )+  np.sin(theta)  )  * np.sqrt( nHalf ) 
    n0Av = n0 *n0 
    n1Av = n1 *n1 
    
    rot =np.array(  [[np.cos(theta ) ,np.sin(theta) ],[-np.sin(theta) ,np.cos(theta ) ]])
    
    
    sigmaQ_ar = np.array( [[val_ar[j,3],val_ar[j,4] ],[val_ar[j,5],val_ar[j,6]]])
    sigmaQ_ar = np.dot(sigmaQ_ar, rot.T  )
    sigmaQ_ar =  np.dot(rot ,  sigmaQ_ar )
    

    sigmaQ_ar[0,0] *= np.sqrt( n0Av* n0Av / nHalf / nHalf)
    sigmaQ_ar[0,1] *= np.sqrt( n0Av* n1Av / nHalf / nHalf)
    sigmaQ_ar[1,0] *= np.sqrt( n1Av* n0Av / nHalf / nHalf)
    sigmaQ_ar[1,1] *= np.sqrt( n1Av* n1Av / nHalf / nHalf)
    
    
    n0Min = n0Av - deltaN
    n1Min = n1Av - deltaN
    n0Max = n0Av + deltaN
    n1Max = n1Av + deltaN

    
    nAr = np.zeros((2,nNmb,nNmb)  )
    n0 = np.linspace(n0Min,n0Max,nNmb)-n0Av
    n1 = np.linspace(n1Min,n1Max,nNmb)-n1Av
    auxAr = np.ones((nNmb,) )
    
    nAr[0] = np.tensordot(n0,auxAr  , axes=0)
    nAr[1] = np.tensordot(auxAr , n1, axes=0)
    
    
    sig = np.linalg.inv(sigmaQ_ar)
    prob = np.tensordot( sig ,  nAr , axes = ([1],[0]) )
    prob =  np.sum(  nAr * prob,0) 
    prob = np.exp(-prob/2)
    
    
    
    return nAr[0]  , nAr[1]   , prob/ np.sum(prob)




def varianceTransformation(val_ar):

    
    varAr = np.reshape( val_ar  ,   (len(val_ar),2,2 )  )
    
    vPl = np.array( [1,1])
    vMi = np.array([1,-1])
    for i in range(len(val_ar)):
        
        sigma = varAr[i]+0
        varAr[i,0,0] = np.dot(vPl, np.dot(sigma,vPl)  ) 
        varAr[i,1,0] = np.dot(vMi, np.dot(sigma,vPl)  ) 
        varAr[i,0,1] = np.dot(vPl, np.dot(sigma,vMi)  ) 
        varAr[i,1,1] = np.dot(vMi, np.dot(sigma,vMi)  ) 
        
        
    return varAr

###############################################################################
###############################################################################
###############################################################################
#Figure 1:  sketch picture

"""

fig = plt.figure(tight_layout=True,figsize=(10,8))


labelSize =22
tickLableSize =0 
                     

#------------------------------------------------------------------------------
ax =  fig.add_axes([0., 0.45, 0.99, 0.55])

image_file =  'pythonProgs/figAuxSpectroscopySetup.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------
ax =  fig.add_axes([0., 0.2, 0.29, 0.25])


x = np.linspace(-3,4,200)
y = np.exp(-x*x/2)
ax.plot(x , y  , color='brown')
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=15 )
ax.fill_between( x, y , color='brown',alpha=0.4)
y = np.exp(-(x-0.5)*(x-0.5)/2)
ax.plot(x , y  , color='brown', linestyle='dashed')


ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=15 )
ax.fill_between( x, y , color='brown',alpha=0.4)
ax.set_xlabel(r'Photon number n', size=labelSize)
ax.set_title(r'Probability     $p_{X,n}$', size=labelSize )
ax.set_xticks([ -2 ,0,2])
ax.set_xticklabels([ r'$-2\sigma$',0,r'$2\sigma$'])
ax.set_xticks([ ] )
ax.set_yticks([] )
ax.annotate(r'$X$', xy=(-1.2, 0.5), xytext=(-3, 0.7),
            arrowprops=dict(facecolor='black', shrink=0.05),size =20
            )
ax.annotate(r'$X + \Delta X$', xy=(1.7, 0.5), xytext=(1.8, 0.8),
            arrowprops=dict(facecolor='black', shrink=0.05),size =20
            )

#------------------------------------------------------------------------------
ax =  fig.add_axes([0.5, 0.1, 0.35, 0.25])


file = 'twoLevelSystem_fisherInfo_detuning-largePower.npy'
val_ar = np.load(pathData + file  )     
ax.plot(  val_ar[:,0], val_ar[:,7]*1e12, label=r'PRFT', color='red',linestyle='solid',lw=4)

ax.set_title(r'Fisher Information $\mathcal{I}_{X} $ ', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'e.g. laser detuning', size=labelSize)
ax.set_xticks([])
ax.set_yticks([])
ax.set_ylim([0,2.9])
ax.annotate(r'best sensitivity ', xy=(-290, 1.9), xytext=(-200, 2.4),
            arrowprops=dict(facecolor='black', shrink=0.05),size =20
            )


#------------------------------------------------------------------------------

arrow1 = FancyArrowPatch((0.4,0.68), (0.25,0.5),
                        arrowstyle='->,head_width=5,head_length=8',
                        connectionstyle="arc3,rad=0.3",
                        linewidth=3,
                        color='brown',
                        transform=fig.transFigure, figure=fig)
fig.patches.append(arrow1)


fig.text(0.25,0.6,'PRFT', size=labelSize*1.2 , color='darkred', rotation=45  )

arrow2 = FancyArrowPatch((0.3,0.4), (0.51,0.39),
                        arrowstyle='->,head_width=5,head_length=8',
                        connectionstyle="arc3,rad=-0.2",
                        linewidth=3,
                        color='darkred',
                        transform=fig.transFigure, figure=fig)
fig.patches.append(arrow2)


#------------------------------------------------------------------------------

fig.savefig('figSpectroscopySetup.pdf',dpi=500)
fig.savefig('figSpectroscopySetup.png',dpi=500)

"""

###############################################################################
###############################################################################
###############################################################################
#Figure 2:  overview picture

"""
fig = plt.figure(tight_layout=True,figsize=(20,8))
             
axFlow = fig.add_axes([0.1, 0.53, 0.55, 0.45])
axRot  = fig.add_axes([-0.05, 0., 0.5, 0.5])
axPha  = fig.add_axes([0.3, 0.0, 0.5, 0.5])
axFixBasis = fig.add_axes([0.7, 0.5, 0.3, 0.4] )
axRotBasis = fig.add_axes([0.7, 0., 0.3, 0.4] )


labelSize=25
tickLableSize=20


#------------------------------------------------------------------------------
ax = axFlow

image_file =  'pythonProgs/figAuxSketchFlow.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------
ax = axFlow

image_file =  'pythonProgs/figAuxSketchFlow.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')



#------------------------------------------------------------------------------
ax = axRot

image_file =  'pythonProgs/figAuxSketchRotation.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------
ax = axPha

image_file =  'pythonProgs/figAuxSketchPhase.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------

ax = axFixBasis

image_file =  'pythonProgs/figAuxFixedBasis.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------

ax = axRotBasis

image_file =  'pythonProgs/figAuxRotatedBasis.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------

fig.text(0.03,0.95,'a) Flow equations',size=labelSize)
fig.text(0.03,0.52,'b) Polarization measurement',size=labelSize)
fig.text(0.4,0.52,'c) Phase measurement',size=labelSize)
fig.text(0.75,0.9,'d) laboratory frame',size=labelSize)
fig.text(0.75,0.41,'e) rotated frame',size=labelSize)


#------------------------------------------------------------------------------

#fig.savefig('figOverview.pdf',dpi=500)
fig.savefig('figOverview.png',dpi=500)


"""


###############################################################################
###############################################################################
###############################################################################
#Figure 3:  sketch of the dissipative two-level system

#see figTwoLevelSystem.png



###############################################################################
###############################################################################
###############################################################################
#Figure 4:  flow equation demonstration

"""
fig = plt.figure(tight_layout=True,figsize=(20,10))

gs = gridspec.GridSpec(100,100, figure=fig,bottom=0.1, top=0.99,left=0.0, right=0.92, hspace= 1)      
gs1= gridspec.GridSpecFromSubplotSpec(2,1, subplot_spec=gs[9:100,10:40],hspace=0.5)
gs10= gridspec.GridSpecFromSubplotSpec(2,1, subplot_spec=gs1[0],hspace=0.0)
gs11= gridspec.GridSpecFromSubplotSpec(2,1, subplot_spec=gs1[1],hspace=0.0)
gs2 = gridspec.GridSpecFromSubplotSpec(2,3, subplot_spec=gs[10:100,50:],hspace=0.4) 


labelSize=24
tickLableSize=20


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------

fName = pathData + 'flowEquations_signalNoise_twoLevelSystem_density+test.npy'
val_ar = np.load(fName ) 
n0_ar ,n1_ar,sigma_ar  = fixedMeasurementBasis(val_ar)

scale = 1e15
scaleX=100


#------------------------------------------------------------------------------
ax = fig.add_subplot(  gs10[0])

ax.plot(val_ar[:,0] *scaleX , n0_ar /scale   , color='green' , label='1',lw=3)
ax.plot(val_ar[:,0]*scaleX  , n1_ar /scale  , color='blue' , linestyle='dashed', label='2',lw=3)


ax.set_xticks([])
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_ylabel(r'Exp $\hat{n}_k$', size=labelSize)


#------------------------------------------------------------------------------
ax =  fig.add_subplot(  gs10[1])

ax.plot(val_ar[:,0]*scaleX , sigma_ar[:,0,0] /scale , color='green' , label='1',lw=3)
ax.plot(val_ar[:,0]*scaleX ,  sigma_ar[:,1,1] /scale  , color='blue' ,  label='2',linestyle='dashed',lw=3 )


ax.legend(fontsize=tickLableSize, loc=[0.02,0.28], title='k', title_fontsize= labelSize, frameon=False)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_ylabel(r'Var $\hat{n}_k  $', size=labelSize)
ax.ticklabel_format(useMathText=True)
ax.set_xticks([])
ax.set_ylim([-0.3,19])


#------------------------------------------------------------------------------
ax = fig.add_subplot(  gs11[0])

theta_ar , n0rot_ar ,n1rot_ar,sigmaRot_ar  = rotatedMeasurementBasis(val_ar)
ax.plot(val_ar[:,0]*scaleX , n0rot_ar /scale   , color='green' , label='1',lw=3)
ax.plot(val_ar[:,0]*scaleX , n1rot_ar /scale  , color='blue' , linestyle='dashed', label='2',lw=3)



ax.legend(fontsize=tickLableSize, loc=[0.7,0.15], title='k', title_fontsize= labelSize, frameon=False)
ax.set_xticks([])
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_ylabel(r'Exp $\hat{n}_{rot,k}$', size=labelSize)


#------------------------------------------------------------------------------
ax =  fig.add_subplot(  gs11[1])

ax.plot(val_ar[:,0]*scaleX , sigmaRot_ar[:,0,0] /scale , color='green' ,lw=3)
ax.plot(val_ar[:,0]*scaleX ,  sigmaRot_ar[:,1,1] /scale  , color='blue' , linestyle='dashed',lw=3 )


ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_ylabel(r'Var $\hat{n}_{rot,k}  $', size=labelSize)
ax.set_xlabel(r'$z$ (cm)', size=labelSize)
ax.ticklabel_format(useMathText=True)
ax.set_ylim([0,15])


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------


idx_ar=  [0,22,44]
text_ls = [r'$z=z_0$' ,r'$z=z_1$',r'$z=z_2$']
deltaN =  5*np.sqrt( 1e15)
nNmb =100
scale = np.sqrt( 1e15)



for i in range(2):
    
    for j in range(3):
        k = idx_ar[j]
        
        if i ==0:
            X , Y   , Z  = probilityDistribution(val_ar, k, deltaN, nNmb)
        else:
            X , Y   , Z  = probilityDistribution(val_ar, k, deltaN, nNmb,True)
        
        ax= fig.add_subplot(  gs2[i,j]) 
        cs = ax.contourf(X/scale,Y/scale,Z ,cmap='OrRd' )
    
    
        ax.set_aspect('equal')
        if j ==1 and i ==0:
            ax.set_xlabel(r'$(n_1-\overline {n}_1)  \,/\, \sqrt{\overline{n}_{+}^{(in)}  }$', size=labelSize)
        if j ==1 and i ==1:
            ax.set_xlabel(r'$(n_{1,rot}-\overline {n}_{1,rot} )  \,/\, \sqrt{\overline{n}_{+}^{(in)}  }$', size=labelSize)
            
        
        if j==0 and i ==0:
            ax.set_ylabel(r'$(n_2 -\overline {n}_2) \,/\, \sqrt{\overline{n}_{+}^{(in)}  } $', size=labelSize)
            
        if j==0 and i ==1:
            ax.set_ylabel(r'$(n_{2,rot} -\overline {n}_{2,rot} ) \,/\, \sqrt{\overline{n}_{+}^{(in)}  } $', size=labelSize)
        
        if i ==0:
            ax.set_title( text_ls[j],size=labelSize)
            ax.set_title( 'z= ' +  str(np.round( val_ar[k,0]*scaleX ,0) ) + ' cm',size=labelSize)
            
            
            
        ax.tick_params(direction='out', length=2, width=1, colors='black',
                       axis='both', grid_alpha=0.,labelsize=tickLableSize )
        ax.set_xticks([-4,0,4])
        ax.set_yticks([-4,0,4])


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------

fig.text(0.06,0.95,'a) laboratory frame',size=labelSize)
fig.text(0.45,0.95,'b) ',size=labelSize)
fig.text(0.06,0.48,'c) rotated frame',size=labelSize)
fig.text(0.45,0.48,'d) ',size=labelSize)


#------------------------------------------------------------------------------

#fig.savefig('figFlowdynamics.pdf',dpi=500)
fig.savefig('figFlowdynamics.png',dpi=500)

"""

###############################################################################
###############################################################################
###############################################################################
#Figure 5: two-level analysis as a function of detuning, cumulants and probabilities 
"""

fig = plt.figure(tight_layout=True,figsize=(20,15) )

gs = gridspec.GridSpec(100,1, figure=fig,bottom=0.05, top=0.93,left=0.07, right=0.98, wspace= 0.2) 
gs1 = gridspec.GridSpecFromSubplotSpec(100,3, subplot_spec=gs[0:57, 0], wspace= 0.2)     
gs11 = gridspec.GridSpecFromSubplotSpec(1,4, subplot_spec=gs1[:30, 0:3],wspace=0.4) 
gs12 = gridspec.GridSpecFromSubplotSpec(1,4, subplot_spec=gs1[50:, 0:3],wspace=0.4) 
gs2 = gridspec.GridSpecFromSubplotSpec(1,5, subplot_spec=gs[65:, 0], wspace= 0.2)     


labelSize=22
tickLableSize=21

xMin =-400
xMax =400


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------
ax00 = fig.add_subplot(gs11[0,0])
ax01 = fig.add_subplot(gs11[0,1])
ax10 = fig.add_subplot(gs11[0,2])
ax11 = fig.add_subplot(gs11[0,3])
ax_ar =[ax00,ax01, ax10,ax11]


fName_ls = [ 
            'twoLevelSystem_fisherInfo_detuning-largePower.npy',
               ]
col='red'

title_ls =[r'$\left< \hat{n}_{+}\right>\, / \;\overline{n}_{+}^{(in)}$',
           r'$\left< \overline{\varphi} \right>$',
           r'Var $ \hat{n}_{+}\, / \; \overline{n}_{+}^{(in)} $',
           r'Var $ \hat{n}_{-} \, / \; \overline{n}_{+}^{(in)}$',
           ]


norm_ls = [4e16,1 ,  4e16,4e16]
yLim_ls = [ [0.95,1.01] ,[-0.7,0.7] , [0.98,1.05],[0.,150] ]

        
for fName in fName_ls:
    val_ar = np.load(pathData + fName ) 
    
    varAr = varianceTransformation(val_ar[:,3:7])
    plot_ar = np.zeros(( len(varAr),4))
    
    
    #val_ar[:,0]
    plot_ar[:,0] = val_ar[:,1]
    plot_ar[:,1] = val_ar[:,2]
    plot_ar[:,2] = varAr[:,0,0]
    plot_ar[:,3] = varAr[:,1,1]
    
    for i in range(4):
            ax =ax_ar[i]
            
            ax.plot(val_ar[:,0]  , plot_ar[:,i]/norm_ls[i]  , color=col, lw=4)
            
            ax.set_xlim([xMin ,xMax])
            ax.set_ylim(yLim_ls[i])
            ax.set_title(title_ls[i], size=labelSize)
            ax.tick_params(direction='out', length=2, width=1, colors='black',
                           axis='both', grid_alpha=0.,labelsize=tickLableSize )
            

            if i ==1:
                ax.set_xlabel( r'                                  detuning $ \epsilon_\Delta  = \epsilon- \omega   $  (MHz)', size=labelSize)


#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------

ax00 = fig.add_subplot(gs12[0,0])
ax01 = fig.add_subplot(gs12[0,1])
ax10 = fig.add_subplot(gs12[0,2])
ax11 = fig.add_subplot(gs12[0,3])
ax_ar =[ax00,ax01,ax10,ax11]



col='orange'
color_ls = ['green','green','red']
lineSyle_ls = ['dotted','dashdot','solid']
lw_ls =[3,2,4]
fName_ls = [ 
            'twoLevelSystem_fisherInfo_detuning-largePower.npy',
               ]
color_ls = ['darkorange']
lineSyle_ls = ['solid']
lw_ls =[4]




title_ls =[r'$\kappa_{+}^{(\delta)}$',
           r'$\kappa_{-}^{(\delta)}$',
           r'$\kappa_{++}^{(\delta)}$',
           r'$\kappa_{--}^{(\delta)}$',
           ]


yLim_ls = [ [-2.5,0.1] ,[-65,65] , [-0.01,2.2],[-10,7400] ]


        
for j,fName in enumerate( fName_ls) :
    val_ar = np.load(pathData + fName ) 
    
    varAr = varianceTransformation(val_ar[:,13:17])
    plot_ar = np.zeros(( len(varAr),4 ))
    
    
    val_ar[:,0]
    plot_ar[:,0] = val_ar[:,11]+val_ar[:,12]
    plot_ar[:,1] = val_ar[:,11]-val_ar[:,12]
    plot_ar[:,2] = varAr[:,0,0]
    plot_ar[:,3] = varAr[:,1,1]
    
    for i in range(4):


            ax= ax_ar[i]
            ax.plot(val_ar[:,0]  , plot_ar[:,i]  , color=color_ls[j],
                    lw=lw_ls[j] , linestyle = lineSyle_ls[j]  )
            
            
            ax.set_xlim([xMin ,xMax])
            ax.set_ylim(yLim_ls[i])
            ax.set_title(title_ls[i], size=labelSize)
            ax.tick_params(direction='out', length=2, width=1, colors='black',
                           axis='both', grid_alpha=0.,labelsize=tickLableSize )
            
            if i ==1:
                ax.set_xlabel( r'                                   detuning $ \epsilon_\Delta  = \epsilon- \omega   $  (MHz)', size=labelSize)
        
        

    
#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------    
    
file = 'twoLevelSystem_fisherInfo_detuning-largePower.npy'
val_ar = np.load(pathData + file  )     


text_ls = [r'$z=z_0$' ,r'$z=z_1$',r'$z=z_2$',r'$z=z_2$',r'$z=z_2$']

idx_ar =[40,70,80,90,100]

for j in range(5):
    
    ax = fig.add_subplot(gs2[j])
    deltaN =  1.5e9
    nNmb =100
    nTot =  4e16
    scale = np.sqrt(nTot)
    
    k =idx_ar[j]
    X , Y   , Z  = probilityDistribution(val_ar,k, deltaN, nNmb, rotQ = True)
    cs = ax.contourf(X/scale,Y/scale,Z ,cmap='OrRd' )



    ax.set_aspect('equal')
    ax.set_xlabel(r'$(n_1-\overline {n}_1) \,/\, \sqrt{\overline{n}_{+}^{(in)}  }$', size=labelSize)
    if j==0:
        ax.set_ylabel(r'$(n_2 -\overline {n}_2) /\, \sqrt{\overline{n}_{+}^{(in)}  }  $', size=labelSize)
    ax.tick_params(direction='out', length=2, width=1, colors='black',
                   axis='both', grid_alpha=0.,labelsize=tickLableSize )
    ax.set_title(r'$\epsilon_\Delta =$ '+str(np.round(val_ar[k,0],0) )+ 'MHz'  ,size=labelSize )
    ax.set_xticks([-4,0,4])
    ax.set_yticks([-4,0,4])

#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------


fig.text(0.01,0.96,r'a)',size=labelSize*1.5)
fig.text(0.01,0.71,r'b)',size=labelSize*1.5)
fig.text(0.01,0.32,r'c)',size=labelSize*1.5)


#------------------------------------------------------------------------------    


#fig.savefig('figDensitySensing.pdf',dpi=500)
fig.savefig('figDensitySensing.png',dpi=500, transparent=True)

"""

###############################################################################
###############################################################################
###############################################################################
#Figure 6: two-level analysis as a function of detuning : Fisher information
"""

fig = plt.figure(tight_layout=True,figsize=(20,6) )
gs = gridspec.GridSpec(1,2, figure=fig,bottom=0.14, top=0.92,left=0.08, right=0.98, wspace= 0.2) 
 
labelSize=26
tickLableSize=23

xMin =-400
xMax =400



#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------
ax =  fig.add_subplot(gs[0,0])

file = 'twoLevelSystem_fisherInfo_detuning-largePower.npy'
val_ar = np.load(pathData + file  )   
  
ax.plot(  val_ar[:,0], val_ar[:,10], label=r'PSN', color='black',linestyle='dashed',lw=2)
ax.plot(  val_ar[:,0], val_ar[:,7], label=r'PRFT', color='red',linestyle='solid',lw=4)
ax.plot(  val_ar[:,0], val_ar[:,30], label=r'ana.', color='black',linestyle='dotted',lw=3)


ax.set_yscale('log')
ax.set_title(r'Fisher Info. $\mathcal{I}_{\rho_A} $  ($m^6$)', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'detuning $ \epsilon_\Delta   $  (MHz)', size=labelSize)
ax.set_ylim([3e-15,1e-11])
ax.set_xlim([xMin ,xMax])
ax.legend(loc ='lower left', fontsize =labelSize, frameon=False , title_fontsize =tickLableSize )
ax.text(-330,5e-12,'Phase', size=labelSize)
ax.text(190,5e-12,'Phase', size=labelSize)
ax.text(-40,5e-12,'Int.', size=labelSize)
ax.axvspan(-400, -40, facecolor='yellow')
ax.axvspan(-40, 40, facecolor='orange')
ax.axvspan(40, 400, facecolor='yellow')



#------------------------------------------------------------------------------
ax =  fig.add_subplot(gs[0,1])


file = 'twoLevelSystem_fisherInfo_detuning-largePower-detuning.npy'


val_ar = np.load(pathData + file  )     
ax.plot(  val_ar[:,0], val_ar[:,10], label=r'PSN', color='black',linestyle='dashed',lw=2)
ax.plot(  val_ar[:,0], val_ar[:,7], label=r'PRFT', color='red',linestyle='solid',lw=4)
ax.plot(  val_ar[:,0], val_ar[:,31], label=r'ana.', color='black',linestyle='dotted',lw=3)


ax.set_yscale('log')
ax.set_title(r'Fisher Info. $\mathcal{I}_{\epsilon} $  (Hz$^{-2}$)', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'detuning $ \epsilon_\Delta $  (MHz)', size=labelSize)
ax.set_ylim([5e8,2e13])
ax.set_xlim([xMin ,xMax])
ax.axvspan(-400, -150, facecolor='yellow')
ax.axvspan(-150, -90, facecolor='orange')
ax.axvspan(-90, 90, facecolor='yellow')
ax.axvspan(90, 150, facecolor='orange')
ax.axvspan(150, 400, facecolor='yellow')


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------

fig.text(0.01,0.95,r'a)',size=labelSize*1.1)
fig.text(0.53,0.95,r'b)',size=labelSize*1.1)


#------------------------------------------------------------------------------    


#fig.savefig('figTwoLevelSystemFisherInfo.pdf',dpi=500)
fig.savefig('figTwoLevelSystemFisherInfo.png',dpi=500, transparent=True)
"""

###############################################################################
###############################################################################
###############################################################################
#Figure 7: Analysis of the Two-level system as a function of dissipation

"""
fig = plt.figure(tight_layout=True,figsize=(20,6) )
gs = gridspec.GridSpec(1,2, figure=fig,bottom=0.14, top=0.93,left=0.08, right=0.98, wspace= 0.2) 


tickLableSize=20
labelSize=22
xMin =-400
xMax =400


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------

ax = ax = fig.add_subplot(gs[0,0])


file_ls = [ 'twoLevelSystem_fisherInfo_pump-detuningZero.npy',
           'twoLevelSystem_fisherInfo_pump-detuningSmall.npy',
           'twoLevelSystem_fisherInfo_pump-detuningMedium.npy',
           'twoLevelSystem_fisherInfo_pump-detuningLarge.npy',
           ]


color_ls =['red', 'orange','green', 'blue']
label_ls =['1','15','30','45']
marker_ls =['o','v','s','x']
nGammaMax=16

for k , file in enumerate(file_ls):
    
    val_ar = np.load(pathData + file  ) 
    ax.scatter(val_ar[:nGammaMax,0],val_ar[:nGammaMax,30] , color =color_ls[k],
               linestyle='dashed', label=label_ls[k], marker= marker_ls[k],s=60)
    ax.plot(val_ar[:,0],val_ar[:,7] , color =color_ls[k] , label=' ')#9
    
    
    
ax.set_xscale('log')
ax.set_yscale('log')
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'Dissipation $\gamma$  (Mhz)', size=labelSize)
ax.set_title(r'Fisher Info. $\mathcal{I}_{\rho_A} $  (m$^6$)', size=labelSize)

ax.legend(loc= 'lower right',fontsize=tickLableSize, title=r'$\epsilon_{\Delta}$ (MHz)', title_fontsize = labelSize, ncol =2)
ax.text(1e-2,1e-14, r'$\propto \gamma$' , size=labelSize*1.7 , color ='black')


#------------------------------------------------------------------------------

ax = ax = fig.add_subplot(gs[0,1])


file_ls = [ 'twoLevelSystem_fisherInfo_pump-detuningZero-detuning.npy',
           'twoLevelSystem_fisherInfo_pump-detuningSmall-detuning.npy',
           'twoLevelSystem_fisherInfo_pump-detuningMedium-detuning.npy',
           'twoLevelSystem_fisherInfo_pump-detuningLarge-detuning.npy',
           ]


color_ls =['red', 'orange','green', 'blue']
label_ls =['1','15','30','45']
marker_ls =['o','v','s','x']


nGammaMax=16

for k , file in enumerate(file_ls):
    
    val_ar = np.load(pathData + file  )   
    ax.plot(val_ar[:,0],val_ar[:,7] , color =color_ls[k] )
    ax.scatter(val_ar[:nGammaMax,0],val_ar[:nGammaMax,31] , 
               color =color_ls[k] , marker= marker_ls[k],s=60)
    
ax.set_xscale('log')
ax.set_yscale('log')
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'Dissipation $\gamma$  (MHz)', size=labelSize)
ax.set_title(r'Fisher Info. $\mathcal{I}_{\epsilon} $  (Hz$^{-2}$)', size=labelSize)


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------


fig.text(0.01,0.93,r'a)',size=labelSize*1.1)
fig.text(0.54,0.93,r'b)',size=labelSize*1.1)


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------

#fig.savefig('figFisherInfoPump.pdf',dpi=500)
fig.savefig('figFisherInfoPump.png',dpi=500, transparent=True)

"""

###############################################################################
###############################################################################
###############################################################################
#Figure 8: analysis of the  extended labmda system: Sketch 

"""
fig = plt.figure(tight_layout=True,figsize=(10,9))

gs = gridspec.GridSpec(100,100, figure=fig,bottom=0.1, top=0.99,left=0.0, right=0.92, hspace= 1)      


labelSize=34
tickLableSize=20


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
ax  =  fig.add_subplot(  gs[:,:]) 

image_file =   'pythonProgs/figAuxExtendedLambdaSystem.png'
image = plt.imread(image_file)
ax.imshow(image)
ax.axis('off')


#------------------------------------------------------------------------------

fig.text(0.06,0.95,'a)',size=labelSize)
fig.text(0.06,0.45,'b)',size=labelSize)


#------------------------------------------------------------------------------    


#fig.savefig('figExtendedLambdaSystemSkecth.pdf',dpi=500)
fig.savefig('figExtendedLambdaSystemSketch.png',dpi=500, transparent=True)

"""

###############################################################################
###############################################################################
###############################################################################
#Figure 9: analysis of the  extended labmda system : cumulants


fig = plt.figure(tight_layout=True,figsize=(20,15) )

gs = gridspec.GridSpec(100,1, figure=fig,bottom=0.05, top=0.93,left=0.07, right=0.98, wspace= 0.2) 
gs1 = gridspec.GridSpecFromSubplotSpec(100,3, subplot_spec=gs[0:57, 0], wspace= 0.2)     
gs11 = gridspec.GridSpecFromSubplotSpec(1,4, subplot_spec=gs1[:30, 0:3],wspace=0.4) 
gs12 = gridspec.GridSpecFromSubplotSpec(1,4, subplot_spec=gs1[50:, 0:3],wspace=0.4) 
gs2 = gridspec.GridSpecFromSubplotSpec(1,5, subplot_spec=gs[65:, 0], wspace= 0.2)     




labelSize=22
tickLableSize=21
xMin =-40
xMax =40

#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------
ax00 = fig.add_subplot(gs11[0])
ax01 = fig.add_subplot(gs11[1])
ax10 = fig.add_subplot(gs11[2])
ax11 = fig.add_subplot(gs11[3])
ax_ar =[ax00,ax01,ax10,ax11]


fName_ls = [ 'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy',
               ]
col='red'

title_ls =[r'$\left< \hat{n}_{+}\right>\, / \;\overline{n}_{+}^{(in)}$',
           r'$\left< \overline{\varphi} \right>$',
           r'Var $ \hat{n}_{+}\, / \; \overline{n}_{+}^{(in)} $',
           r'Var $ \hat{n}_{-} \, / \; \overline{n}_{+}^{(in)}$',
           ]


norm_ls = [4e13,1 ,  4e13,4e13]
yLim_ls = [ [0.82,1.02] ,[-8,8] , [0.92,1.3],[0.,1250] ]
        
for j, fName in enumerate( fName_ls ):
    val_ar = np.load(pathData + fName ) 
    
    varAr = varianceTransformation(val_ar[:,3:7])
    plot_ar = np.zeros(( len(varAr),4 ))
    
    
    val_ar[:,0]
    plot_ar[:,0] = val_ar[:,1]
    plot_ar[:,1] = val_ar[:,2]
    plot_ar[:,2] = varAr[:,0,0]
    plot_ar[:,3] = varAr[:,1,1]
    
    for i in range(4):
            ax =ax_ar[i]
            
            
            ax.plot(val_ar[:,0]  , plot_ar[:,i]/norm_ls[i]  , color=col, lw=4)
            
            
            ax.set_xlim([xMin ,xMax])
            ax.set_ylim(yLim_ls[i])
            ax.set_title(title_ls[i], size=labelSize)
            ax.tick_params(direction='out', length=2, width=1, colors='black',
                           axis='both', grid_alpha=0.,labelsize=tickLableSize )
            
            
            if i ==1:
                ax.set_xlabel( r'                      detuning $\epsilon_{ba,\Delta} = (\epsilon_b -\epsilon_a )-\omega $ (Mhz)', size=labelSize)
        

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
ax00 = fig.add_subplot(gs12[0])
ax01 = fig.add_subplot(gs12[1])
ax10 = fig.add_subplot(gs12[2])
ax11 = fig.add_subplot(gs12[3])
ax_ar =[ax00,ax01,ax10,ax11]


fName_ls = [ 
            'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy',
               ]


color_ls = ['darkorange']
lineSyle_ls = ['solid']
lw_ls =[4]
title_ls =[r'$\kappa_{+}^{(\delta)}$',
           r'$\kappa_{-}^{(\delta)}$',
           r'$\kappa_{++}^{(\delta)}$',
           r'$\kappa_{--}^{(\delta)}$',
           ]
yLim_ls = [ [-0.06,0.01] ,[-1.5,1.5] , [-0.01,0.07],[-10,150] ]



        
for j,fName in enumerate(fName_ls):
    val_ar = np.load(pathData + fName ) 
    
    varAr = varianceTransformation(val_ar[:,13:17])
    plot_ar = np.zeros(( len(varAr),4 ))
    
    
    val_ar[:,0]
    plot_ar[:,0] = val_ar[:,11]+val_ar[:,12]
    plot_ar[:,1] = val_ar[:,11]-val_ar[:,12]
    
    plot_ar[:,2] = varAr[:,0,0]
    plot_ar[:,3] = varAr[:,1,1]
    
    for i in range(4):
        ax =ax_ar[i]
        ax.plot(val_ar[:,0]  , plot_ar[:,i]  , color=color_ls[j], 
                linestyle =lineSyle_ls[j] ,lw =lw_ls[j])
        
        ax.set_xlim([xMin ,xMax])
        ax.set_ylim(yLim_ls[i])
        ax.set_title(title_ls[i], size=labelSize)
        ax.tick_params(direction='out', length=2, width=1, colors='black',
                       axis='both', grid_alpha=0.,labelsize=tickLableSize )
        
        if i ==1:
            ax.set_xlabel( r'                      detuning $\epsilon_{ba,\Delta} = (\epsilon_b -\epsilon_a )-\omega $ (Mhz)', size=labelSize)
    
    
#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------    
    
file = 'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy'
val_ar = np.load(pathData + file  )     

text_ls = [r'$z=z_0$' ,r'$z=z_1$',r'$z=z_2$',r'$z=z_2$',r'$z=z_2$']
idx_ar =[300,350,400,450,500]

for j in range(5):
    
    ax = fig.add_subplot(gs2[j])
    deltaN =  4e7
    nNmb =100
    nTot=4e13
    scale= np.sqrt(nTot)
    
    k =idx_ar[j]
    X , Y   , Z  = probilityDistribution(val_ar,k, deltaN, nNmb, rotQ = True)
    cs = ax.contourf(X/scale,Y/scale,Z ,cmap='OrRd' )


    ax.set_aspect('equal')
    ax.set_xlabel(r'$(n_1-\overline {n}_1) \,/\, \sqrt{\overline{n}_{+}^{(in)}  }$', size=labelSize)
    if j==0:
        ax.set_ylabel(r'$(n_2-\overline {n}_2) \,/\, \sqrt{\overline{n}_{+}^{(in)}  }$', size=labelSize)
    ax.tick_params(direction='out', length=2, width=1, colors='black',
                   axis='both', grid_alpha=0.,labelsize=tickLableSize )
    ax.set_title( text_ls[j],size=labelSize)
    ax.set_title(r' $\epsilon_{ba,\Delta}$ = '+str(np.round(val_ar[k,0],1) )+ 'MHz'  ,size=labelSize )
    ax.set_xticks([-4,0,4])
    ax.set_yticks([-4,0,4])


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------


fig.text(0.01,0.96,r'a)',size=labelSize*1.5)
fig.text(0.01,0.71,r'b)',size=labelSize*1.5)
fig.text(0.01,0.32,r'c)',size=labelSize*1.5)


#------------------------------------------------------------------------------    

#fig.savefig('figExtendedLambdaSystemStatistics.pdf',dpi=500)
fig.savefig('figExtendedLambdaSystemStatistics.png',dpi=500, transparent=True)


###############################################################################
###############################################################################
###############################################################################
#Figure 10: analysis of the  extended labmda system: Fisher Information 
"""

fig = plt.figure(tight_layout=True,figsize=(20,9) )

gs = gridspec.GridSpec(1,100, figure=fig,bottom=0.09, top=0.95,left=0.06, right=0.99, wspace= 0.3) 
gs0 = gridspec.GridSpecFromSubplotSpec(100,1, subplot_spec=gs[0, 0:52], wspace= 0.2)    
gs1 = gridspec.GridSpecFromSubplotSpec(2,1, subplot_spec=gs[0, 60:], hspace= 0.4)     
   

tickLableSize=23
labelSize=25
xMin =-40
xMax =40

#-----------------------------------------------------------------------------

#------------------------------------------------------------------------------
ax =  fig.add_subplot(gs0[10:90,0])


file = 'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy'
val_ar = np.load(pathData + file  )     
ax.plot(  val_ar[:,0], val_ar[:,7], label=r'PRFT', color='red',linestyle='solid',lw=4)
ax.plot(  val_ar[:,0], val_ar[:,10], label=r'PSN', color='black',linestyle='dashed',lw=2)


ax.set_yscale('log')
ax.set_title(r'Fisher Info. $\mathcal{I}_{\Omega_{S}} $  (Hz$^{-2}$)', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlabel( r'detuning $\epsilon_{ba,\Delta}  $ (Mhz)', size=labelSize)
ax.set_ylim([1e8 ,1e14])
ax.set_xlim([xMin ,xMax])
ax.legend(loc ='lower center', fontsize =tickLableSize*0.9, frameon=False ,
          title_fontsize =tickLableSize )
ax.axvspan(-24, -40, facecolor='yellow')
ax.axvspan(-22.5, -24, facecolor='orange')
ax.axvspan(-19,-22.5, facecolor='yellow')
ax.axvspan(-17, -19, facecolor='orange')
ax.axvspan(-17, -0.5, facecolor='yellow')
ax.axvspan(-0.5, 0.5, facecolor='orange')
ax.axvspan(0.5,5, facecolor='yellow')
ax.axvspan(0.5, 17, facecolor='yellow')
ax.axvspan(17, 19, facecolor='orange')
ax.axvspan(19,22.5, facecolor='yellow')
ax.axvspan(22.5, 24, facecolor='orange')
ax.axvspan(24, 40, facecolor='yellow')


#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
ax =  fig.add_subplot(gs1[0,0])

file = 'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy'
val_ar = np.load(pathData + file  )     
ax.plot(  val_ar[:,0], val_ar[:,7], label=r'PRFT', color='red',linestyle='solid',lw=4)
ax.plot(  val_ar[:,0], val_ar[:,10], label=r'SN', color='black',linestyle='dashed',lw=2)


ax.set_yscale('log')
ax.set_title(r'Fisher Info. $\mathcal{I}_{\Omega_S } $  (Hz$^{-2}$)', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_xlim([-3,3])
ax.set_ylim([5e9 ,1e14])
ax.axvspan(-5, -0.5, facecolor='yellow')
ax.axvspan(-0.5, 0.5, facecolor='orange')
ax.axvspan(0.5,5, facecolor='yellow')
ax.set_xlabel( r'detuning $\epsilon_{ba,\Delta}  $  (Mhz)', size=labelSize)


#------------------------------------------------------------------------------
ax =  fig.add_subplot(gs1[1,0])

file = 'extendedLambdaSystem_fisherInfo_detuning1-smallPower-LO.npy'
val_ar = np.load(pathData + file  )     
ax.plot(  val_ar[:,0], val_ar[:,7], label=r'PRFT', color='red',linestyle='solid',lw=4)
ax.plot(  val_ar[:,0], val_ar[:,10], label=r'SN', color='black',linestyle='dashed',lw=2)

ax.set_yscale('log')
ax.set_title(r'Fisher Info. $\mathcal{I}_{\Omega_S } $  (Hz$^{-2}$)', size=labelSize)
ax.tick_params(direction='out', length=2, width=1, colors='black',
               axis='both', grid_alpha=0.,labelsize=tickLableSize )
ax.set_ylim([5e8 ,2e14])
ax.set_xlim([10,30])
ax.axvspan(10, 17, facecolor='yellow')
ax.axvspan(17, 19, facecolor='orange')
ax.axvspan(19,22.5, facecolor='yellow')
ax.axvspan(22.5, 24, facecolor='orange')
ax.axvspan(24, 30, facecolor='yellow')
ax.set_xlabel( r'detuning $\epsilon_{ba,\Delta}  $  (Mhz)', size=labelSize)


#-----------------------------------------------------------------------------
#------------------------------------------------------------------------------


fig.text(0.06,0.95,r'a)',size=labelSize*1.1)
fig.text(0.57,0.95,r'b)',size=labelSize*1.1)
fig.text(0.57,0.46,r'c)',size=labelSize*1.1)

#------------------------------------------------------------------------------    


#fig.savefig('figExtendedLambdaSystemFisherInfo.pdf',dpi=500)
fig.savefig('figExtendedLambdaSystemFisherInfo.png',dpi=500, transparent=True)
"""


###############################################################################
###############################################################################
###############################################################################

